<?php $__env->startSection('content'); ?>
    <div class="row gy-5 gx-lg-5 align-items-center">
        <div class="col-lg-6">
            <div class="headtail-body">
                <?php echo $__env->make($activeTemplate . 'partials.game_shape', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <div class="headtail-body__flip">
                    <div class="spin-card">
                        <div class="wheel-wrapper">
                            <div class="arrow text-center">
                                <img src="<?php echo e(asset($activeTemplateTrue . 'images/play/down.png')); ?>" height="50" width="50">
                            </div>
                            <div class="wheel the_wheel text-center">
                                <canvas class="w-100" id="canvas" width="434" height="434">
                                    <p class="text-white" align="center"><?php echo app('translator')->get("Sorry, your browser doesn't support canvas. Please try another."); ?></p>
                                </canvas>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-6">
            <div class="headtail-wrapper">
                <h4 class="game-contet-title"><?php echo app('translator')->get('Current Balance'); ?>: <span class="text bal"><?php echo e(showAmount(auth()->user()->balance, currencyFormat: false)); ?></span> <?php echo e(__(gs('cur_text'))); ?></h4>
                <form id="game" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="form-group">
                        <div class="input-group">
                            <span class="input-group-text"><?php echo e(gs('cur_sym')); ?></span>
                            <input type="number" step="any" class="form-control form--control" placeholder="<?php echo app('translator')->get('Enter amount'); ?>" name="invest" value="<?php echo e(old('invest')); ?>">
                            <button type="button" class="input-group-text minmax-btn minBtn"><?php echo app('translator')->get('Min'); ?></button>
                            <button type="button" class="input-group-text minmax-btn maxBtn"><?php echo app('translator')->get('Max'); ?></button>
                        </div>
                        <small class="fw-light mt-3 d-inline-block input-inner-note"><i
                               class="fas fa-info-circle mr-2"></i>
                            <?php echo app('translator')->get('Minimum'); ?>
                            : <?php echo e(showAmount($game->min_limit)); ?> | <?php echo app('translator')->get('Maximum'); ?>
                            : <?php echo e(showAmount($game->max_limit)); ?> |
                            <span class="text--warning"><?php echo app('translator')->get('Win Amount'); ?>
                                <?php if($game->invest_back == 1): ?>
                                    <?php echo e(getAmount($game->win + 100)); ?>

                                <?php else: ?>
                                    <?php echo e(getAmount($game->win)); ?>

                                <?php endif; ?> %
                            </span>
                        </small>
                    </div>

                    <div class="headtail-slect">
                        <div class="headtail-slect__box game-select-box black gmimg">
                            <div class="headtail-slect__image">
                                <img src="<?php echo e(asset($activeTemplateTrue . 'images/play/moneyblack.png')); ?>" alt="game-image">
                            </div>
                        </div>
                        <div class="headtail-slect__box game-select-box red gmimg">
                            <div class="headtail-slect__image">
                                <img src="<?php echo e(asset($activeTemplateTrue . 'images/play/money.png')); ?>" alt="game-image">
                            </div>
                        </div>
                        <input name="choose" type="hidden">
                    </div>

                    <div class="form-submit game-playbtn">
                        <button type="submit" class="btn btn--gradient w-100"><?php echo app('translator')->get('Play Now'); ?></button>
                    </div>
                    <button type="button" class="d-block text-white text-center mx-auto mt-3" data-bs-toggle="modal" data-bs-target="#exampleModalCenter">
                        <i class="fas fa-info-circle mr-2"></i> <?php echo app('translator')->get('Game Instruction'); ?>
                    </button>
                </form>
            </div>
        </div>
    </div>


    <!-- Modal -->
    <div class="modal custom--modal fade" id="exampleModalCenter" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content section--bg">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle"><?php echo app('translator')->get('Game Rule'); ?></h5>
                    <span class="close" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <i class="las la-times"></i>
                    </span>
                </div>
                <div class="modal-body">
                    <?php echo $game->instruction ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('style'); ?>
    <style type="text/css">
        .the_wheel {
            max-width: 300px !important;
        }

        @media screen and (max-width:1399px) {
            .the_wheel {
                max-width: 250px !important;
            }
        }

        @media screen and (max-width:1199px) {
            .the_wheel {
                max-width: 180px !important;
            }
        }

        @media screen and (max-width:991px) {
            .the_wheel {
                max-width: 230px !important;
            }
        }

        @media screen and (max-width:574px) {
            .the_wheel {
                max-width: 150px !important;
            }
        }

        @media screen and (max-width:375px) {
            .the_wheel {
                max-width: 120px !important;
            }
        }
    </style>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('script-lib'); ?>
    <script src="<?php echo e(asset('assets/global/js/game/TweenMax.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/global/js/game/Winwheel.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/global/js/game/spinFunctions.js')); ?>"></script>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('script'); ?>
    <script>
        "use strict";

        let investField = $("[name=invest]");
        let minLimit = Number("<?php echo e($game->min_limit); ?>");
        let maxLimit = Number("<?php echo e($game->max_limit); ?>");
        let currency = "<?php echo e(gs('cur_text')); ?>";
        let audio;

        $(".minBtn").on('click', function(e) {
            audio = new Audio(`<?php echo e(asset('assets/audio/click.mp3')); ?>`);
            audio.play()
            investField.val(minLimit);
        });

        $(".maxBtn").on('click', function(e) {
            audio = new Audio(`<?php echo e(asset('assets/audio/click.mp3')); ?>`);
            audio.play()
            investField.val(maxLimit);
        });

        $('input[name=invest]').keypress(function(e) {
            var character = String.fromCharCode(e.keyCode)
            var newValue = this.value + character;
            if (isNaN(newValue) || hasDecimalPlace(newValue, 3)) {
                e.preventDefault();
                return false;
            }
        });

        function hasDecimalPlace(value, x) {
            var pointIndex = value.indexOf('.');
            return pointIndex >= 0 && pointIndex < value.length - x;
        }

        $('#game').on('submit', function(e) {
            e.preventDefault();
            if (!$('[name=invest]').val()) {
                notify('error', 'Invest amount is required')
                return;
            }
            if (!$('[name=choose]').val()) {
                notify('error', 'Spin selection is required')
                return;
            }
            audio = new Audio(`<?php echo e(asset('assets/audio/spin-wheel.mp3')); ?>`);
            audio.play()
            beforeProcess();
            var data = $(this).serialize();
            var url = "<?php echo e(route('user.play.game.invest', 'spin_wheel')); ?>";
            game(url, data);
        });

        function endGame(data) {
            var url = "<?php echo e(route('user.play.game.end', 'spin_wheel')); ?>";
            audio.pause()
            complete(data, url)
        }

        function playAudio(filename) {
            var audio = new Audio(`<?php echo e(asset('assets/audio')); ?>/${filename}`);
            audio.play();
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/club/public_html/core/resources/views/templates/sunfyre/user/games/spin_wheel.blade.php ENDPATH**/ ?>