<?php $__env->startSection('content'); ?>
    <div class="row gy-5 gx-lg-5 align-items-center">
        <div class="col-lg-6">
            <div class="headtail-body">
                <?php echo $__env->make($activeTemplate . 'partials.game_shape', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <div class="headtail-body__flip">
                    <div class="sld">
                        <div class="imgs sld-wrapper position-relative text-center">
                            <div class="img1">
                                <img src="<?php echo e(asset($activeTemplateTrue . 'images/games/rock.png')); ?>">
                            </div>
                            <div class="img2 op-0">
                                <img src="<?php echo e(asset($activeTemplateTrue . 'images/games/paper.png')); ?>">
                            </div>
                            <div class="img3 op-0">
                                <img src="<?php echo e(asset($activeTemplateTrue . 'images/games/scissors.png')); ?>">
                            </div>
                        </div>
                        <div class="result d-none align-items-center text-center">
                            <div class="">
                                <img class="im-1" src="<?php echo e(asset($activeTemplateTrue . 'images/games/rock.png')); ?>">
                            </div>
                            <h1 class="opac-0 vs-title"><?php echo app('translator')->get('VS'); ?></h1>
                            <div class="">
                                <img class="im-2 opac-0" src="<?php echo e(asset($activeTemplateTrue . 'images/games/paper.png')); ?>">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-6">
            <div class="headtail-wrapper">
                <h4 class="game-contet-title"><?php echo app('translator')->get('Current Balance'); ?>: <span class="text bal"><?php echo e(showAmount(auth()->user()->balance, currencyFormat: false)); ?> </span> <?php echo e(__(gs('cur_text'))); ?></h4>
                <form id="game" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="form-group">
                        <div class="input-group">
                            <span class="input-group-text"><?php echo e(gs('cur_sym')); ?></span>
                            <input type="number" step="any" class="form-control form--control" placeholder="<?php echo app('translator')->get('Enter amount'); ?>" name="invest" value="<?php echo e(old('invest')); ?>">
                            <button type="button" class="input-group-text minmax-btn minBtn"><?php echo app('translator')->get('Min'); ?></button>
                            <button type="button" class="input-group-text minmax-btn maxBtn"><?php echo app('translator')->get('Max'); ?></button>
                        </div>
                        <small class="fw-light mt-3 d-inline-block input-inner-note"><i
                               class="fas fa-info-circle mr-2"></i>
                            <?php echo app('translator')->get('Minimum'); ?>
                            : <?php echo e(showAmount($game->min_limit)); ?> | <?php echo app('translator')->get('Maximum'); ?>
                            : <?php echo e(showAmount($game->max_limit)); ?> |
                            <span class="text--warning"><?php echo app('translator')->get('Win Amount'); ?>
                                <?php if($game->invest_back == 1): ?>
                                    <?php echo e(getAmount($game->win + 100)); ?>

                                <?php else: ?>
                                    <?php echo e(getAmount($game->win)); ?>

                                <?php endif; ?> %
                            </span>
                        </small>
                    </div>

                    <div class="headtail-slect">
                        <div class="rockselect-box game-select-box rock">
                            <div class="headtail-slect__image">
                                <img src="<?php echo e(asset($activeTemplateTrue . '/images/games/rock.pn')); ?>g" alt="game-image">
                            </div>
                        </div>
                        <div class="rockselect-box game-select-box paper">
                            <div class="headtail-slect__image">
                                <img src="<?php echo e(asset($activeTemplateTrue . '/images/games/paper.png')); ?>" alt="game-image">
                            </div>
                        </div>
                        <div class="rockselect-box game-select-box scissors">
                            <div class="headtail-slect__image">
                                <img src="<?php echo e(asset($activeTemplateTrue . '/images/games/scissors.png')); ?>" alt="game-image">
                            </div>
                        </div>
                        <input name="choose" type="hidden">
                    </div>

                    <div class="form-submit game-playbtn">
                        <button type="submit" class="btn btn--gradient w-100"><?php echo app('translator')->get('Play Now'); ?></button>
                    </div>
                    <button type="button" class="d-block text-white text-center mx-auto mt-3" data-bs-toggle="modal" data-bs-target="#exampleModalCenter"><i
                           class="fas fa-info-circle mr-2"></i>
                        <?php echo app('translator')->get('Game Instruction'); ?>
                    </button>
                </form>
            </div>
        </div>
    </div>


    <!-- Modal -->
    <div class="modal custom--modal fade" id="exampleModalCenter" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content section--bg">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle"><?php echo app('translator')->get('Game Rule'); ?></h5>
                    <span class="close" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <i class="las la-times"></i>
                    </span>
                </div>
                <div class="modal-body">
                    <?php echo $game->instruction ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
    <style type="text/css">
        .result {
            display: flex;
        }

        .game-details-left {
            border-radius: 5px;
        }

        .img1 {
            position: relative;
        }

        .img2 {
            position: absolute;
            height: 100%;
            width: 100%;
            left: 0;
            top: 0;
        }

        .img3 {
            position: absolute;
            height: 100%;
            width: 100%;
            left: 0;
            top: 0;
        }

        .op-1 {
            opacity: 1;
        }

        .op-0 {
            opacity: 0;
        }

        .vs-title {
            font-size: 20px;
        }

        .game-details-left {
            padding: 30px 10px;
        }

        @media screen and (min-width:576px) {
            .vs-title {
                font-size: 30px;
            }

            .game-details-left {
                padding: 50px;
            }
        }

        @media (max-width:424px) {
            .imgs.sld-wrapper {
                max-width: 171px;
            }

            .headtail-slect__image img {
                max-width: 80px;
                width: unset !important;
            }
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script-lib'); ?>
    <script src="<?php echo e(asset('assets/global/js/game/rockpaper.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        "use strict";
        let investField = $("[name=invest]");
        let minLimit = Number("<?php echo e($game->min_limit); ?>");
        let maxLimit = Number("<?php echo e($game->max_limit); ?>");
        let currency = "<?php echo e(gs('cur_text')); ?>";
        let audio;

        $(".minBtn").on('click', function(e) {
            audio = new Audio(`<?php echo e(asset('assets/audio/click.mp3')); ?>`);
            audio.play()
            investField.val(minLimit);
        });

        $(".maxBtn").on('click', function(e) {
            audio = new Audio(`<?php echo e(asset('assets/audio/click.mp3')); ?>`);
            audio.play()
            investField.val(maxLimit);
        });


        $('#game').on('submit', function(e) {
            e.preventDefault();
            if (!$('[name=invest]').val()) {
                notify('error', 'Invest amount is required')
                return;
            }

            if (!$('[name=choose]').val()) {
                notify('error', 'Choose field is required')
                return;
            }
            audio = new Audio(`<?php echo e(asset('assets/audio/rock-paper.mp3')); ?>`);
            audio.play()
            $('.cd-ft').html('');
            $('.cmn-btn').html('<i class="la la-gear fa-spin"></i> Processing...');
            $('.cmn-btn').attr('disabled', '');
            var data = $(this).serialize();
            var url = "<?php echo e(route('user.play.game.invest', 'rock_paper_scissors')); ?>";
            game(data, url);
        });

        function endGame(data) {
            var url = '<?php echo e(route('user.play.game.end', 'rock_paper_scissors')); ?>';
            var img1 = '<?php echo e(asset($activeTemplateTrue . 'images/play/rock.png')); ?>';
            var img2 = '<?php echo e(asset($activeTemplateTrue . 'images/play/paper.png')); ?>';
            var img3 = '<?php echo e(asset($activeTemplateTrue . 'images/play/scissors.png')); ?>';
            var imgObj = {
                img1,
                img2,
                img3
            };
            audio.pause()
            complete(data, url, imgObj);
        }

        function playAudio(filename) {
            var audio = new Audio(`<?php echo e(asset('assets/audio')); ?>/${filename}`);
            audio.play();
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/easyearning/public_html/core/resources/views/templates/sunfyre/user/games/rock_paper_scissors.blade.php ENDPATH**/ ?>