<?php $__env->startSection('content'); ?>
    <section class="transection-section">
        <?php echo $__env->make($activeTemplate . 'partials.search_form', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="latest-transection">
            <div class="transection-table-scroller">
                <table class="transection-table table table--responsive--xl">
                    <thead>
                        <tr>
                            <th><?php echo app('translator')->get('Gateway | Transaction'); ?></th>
                            <th><?php echo app('translator')->get('Initiated'); ?></th>
                            <th><?php echo app('translator')->get('Amount'); ?></th>
                            <th><?php echo app('translator')->get('Conversion'); ?></th>
                            <th><?php echo app('translator')->get('Status'); ?></th>
                            <th><?php echo app('translator')->get('Details'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $deposits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deposit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td>
                                    <div class="text-lg-start text-end">
                                        <span class="fw-bold">
                                            <span class="text--base">
                                                <?php if($deposit->method_code < 5000): ?>
                                                    <?php echo e(__(@$deposit->gateway->name)); ?>

                                                <?php else: ?>
                                                    <?php echo app('translator')->get('Google Pay'); ?>
                                                <?php endif; ?>
                                            </span>
                                        </span>
                                        <br>
                                        <small> <?php echo e($deposit->trx); ?> </small>
                                    </div>
                                </td>

                                <td>
                                    <div>
                                        <?php echo e(showDateTime($deposit->created_at)); ?><br><?php echo e(diffForHumans($deposit->created_at)); ?>

                                    </div>
                                </td>
                                <td>
                                    <div>
                                        <?php echo e(showAmount($deposit->amount)); ?> + <span class="text--danger" data-bs-toggle="tooltip" title="<?php echo app('translator')->get('Processing Charge'); ?>"><?php echo e(showAmount($deposit->charge)); ?> </span>
                                        <br>
                                        <strong data-bs-toggle="tooltip" title="<?php echo app('translator')->get('Amount with charge'); ?>">
                                            <?php echo e(showAmount($deposit->amount + $deposit->charge)); ?>

                                        </strong>
                                    </div>
                                </td>
                                <td>
                                    <div>
                                        <?php echo e(showAmount(1)); ?> = <?php echo e(showAmount($deposit->rate, currencyFormat: false)); ?> <?php echo e(__($deposit->method_currency)); ?>

                                        <br>
                                        <strong><?php echo e(showAmount($deposit->final_amount, currencyFormat: false)); ?> <?php echo e(__($deposit->method_currency)); ?></strong>
                                    </div>
                                </td>
                                <td>
                                    <?php echo $deposit->statusBadge ?>
                                </td>
                                <?php
                                    $details = [];
                                    if ($deposit->method_code >= 1000 && $deposit->method_code <= 5000) {
                                        foreach (@$deposit->detail ?? [] as $key => $info) {
                                            $details[] = $info;
                                            if ($info->type == 'file') {
                                                $details[$key]->value = route('user.download.attachment', encrypt(getFilePath('verify') . '/' . $info->value));
                                            }
                                        }
                                    }
                                ?>
                                <td>
                                    <?php if($deposit->method_code >= 1000 && $deposit->method_code <= 5000): ?>
                                        <a href="javascript:void(0)" class="btn btn--base btn--sm detailBtn" data-info="<?php echo e(json_encode($details)); ?>"
                                           <?php if($deposit->status == Status::PAYMENT_REJECT): ?> data-admin_feedback="<?php echo e($deposit->admin_feedback); ?>" <?php endif; ?>>
                                            <i class="fas fa-desktop"></i>
                                        </a>
                                    <?php else: ?>
                                        <button class="btn btn--success btn--sm" type="button" data-bs-toggle="tooltip" title="<?php echo app('translator')->get('Automatically processed'); ?>">
                                            <i class="fas fa-check"></i>
                                        </button>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
                <?php echo e(paginateLinks($deposits)); ?>

            </div>
        </div>
    </section>

    <div class="modal custom--modal fade" id="detailModal" role="dialog" tabindex="-1">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo app('translator')->get('Details'); ?></h5>
                    <span class="close" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <i class="las la-times"></i>
                    </span>
                </div>
                <div class="modal-body">
                    <ul class="list-group list-group-flush payment-list userData mb-2">
                    </ul>
                    <div class="feedback"></div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            $('.detailBtn').on('click', function() {
                var modal = $('#detailModal');

                var userData = $(this).data('info');
                var html = '';
                if (userData) {
                    userData.forEach(element => {
                        if (element.type != 'file') {
                            html += `
                            <li class="list-group-item d-flex justify-content-between align-items-center px-0">
                                <span>${element.name}</span>
                                <span">${element.value}</span>
                            </li>`;
                        }
                    });
                }

                modal.find('.userData').html(html);

                if ($(this).data('admin_feedback') != undefined) {
                    var adminFeedback = `
                        <div class="my-3">
                            <strong><?php echo app('translator')->get('Admin Feedback'); ?></strong>
                            <p>${$(this).data('admin_feedback')}</p>
                        </div>
                    `;
                } else {
                    var adminFeedback = '';
                }

                modal.find('.feedback').html(adminFeedback);
                modal.modal('show');
            });

            var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
            var tooltipList = tooltipTriggerList.map(function(tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl)
            })
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/club/public_html/core/resources/views/templates/sunfyre/user/deposit_history.blade.php ENDPATH**/ ?>