<?php
    $trxContent = getContent('trx_win.content', true);
    $latestWinners = \App\Models\GameLog::where('win_status', '!=', 0)
        ->where('win_amo', '>', '0')
        ->take(6)
        ->with(['user', 'game'])
        ->latest('id')
        ->get();
    $transactions = \App\Models\Transaction::with('user')->latest()->limit(7)->get();
?>

<section class="winner-section py-50">
    <div class="container">
        <div class="section-heading">
            <h1 class="section-heading__title"><?php echo e(__(@$trxContent->data_values->heading)); ?></h1>
            <p class="section-heading__desc"><?php echo e(__(@$trxContent->data_values->subheading)); ?></p>
        </div>

        <div class="winner-section-wrapper">
            <div class="latest-winner">
                <h4 class="latest-winner__heading"><?php echo app('translator')->get('Latest Winner'); ?></h4>
                <div class="latest-winner__list">
                    <?php $__currentLoopData = $latestWinners; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $winner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="latest-winner-item">
                            <h6 class="latest-winner-item__title"><?php echo e(__($winner->user->fullname)); ?></h6>
                            <div class="flex-between">
                                <p class="latest-winner-item__name"><?php echo e(__(@$winner->game->name)); ?></p>
                                <h6 class="latest-winner-item__amount"><?php echo e(showAmount($winner->win_amo)); ?></h6>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            <div class="latest-transection">
                <div class="transection-table-scroller">
                    <table class="transection-table table table--responsive--xl">
                        <thead>
                            <tr>
                                <th><?php echo app('translator')->get('Transaction ID'); ?></th>
                                <th><?php echo app('translator')->get('Username'); ?></th>
                                <th><?php echo app('translator')->get('Data'); ?></th>
                                <th><?php echo app('translator')->get('Amount'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td>#<?php echo e($transaction->trx); ?></td>
                                    <td><?php echo e($transaction->user->username); ?></td>
                                    <td><?php echo e(showDateTime($transaction->created_at)); ?></td>
                                    <td><?php echo e(showAmount($transaction->amount)); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="100%" class="text-center"><?php echo e(__($emptyMessage)); ?></td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</section>
<?php /**PATH /home/xbetwin/public_html/core/resources/views/templates/sunfyre/sections/trx_win.blade.php ENDPATH**/ ?>