<?php $__env->startSection('content'); ?>
    <section class="transection-section">
        <?php echo $__env->make($activeTemplate . 'partials.search_form', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="latest-transection">
            <div class="transection-table-scroller">
                <table class="transection-table table table--responsive--xl">
                    <thead>
                        <tr>
                            <th><?php echo app('translator')->get('Gateway | Transaction'); ?></th>
                            <th><?php echo app('translator')->get('Initiated'); ?></th>
                            <th><?php echo app('translator')->get('Amount'); ?></th>
                            <th><?php echo app('translator')->get('Conversion'); ?></th>
                            <th><?php echo app('translator')->get('Status'); ?></th>
                            <th><?php echo app('translator')->get('Action'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $withdraws; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $withdraw): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <?php
                                $details = [];
                                foreach ($withdraw->withdraw_information as $key => $info) {
                                    $details[] = $info;
                                    if ($info->type == 'file') {
                                        $details[$key]->value = route('user.download.attachment', encrypt(getFilePath('verify') . '/' . $info->value));
                                    }
                                }
                            ?>
                            <tr>
                                <td>
                                    <div class="text-end text-lg-start">
                                        <span class="fw-bold"><span class="text--base"> <?php echo e(__(@$withdraw->method->name)); ?></span></span>
                                        <br>
                                        <small><?php echo e($withdraw->trx); ?></small>
                                    </div>
                                </td>
                                <td>
                                    <span><?php echo e(showDateTime($withdraw->created_at)); ?> <br> <?php echo e(diffForHumans($withdraw->created_at)); ?></span>
                                </td>
                                <td>
                                    <div>
                                        <?php echo e(showAmount($withdraw->amount)); ?> - <span class="text--danger" data-bs-toggle="tooltip" title="<?php echo app('translator')->get('Processing Charge'); ?>"><?php echo e(showAmount($withdraw->charge)); ?> </span>
                                        <br>
                                        <strong data-bs-toggle="tooltip" title="<?php echo app('translator')->get('Amount after charge'); ?>">
                                            <?php echo e(showAmount($withdraw->amount - $withdraw->charge)); ?>

                                        </strong>
                                    </div>

                                </td>
                                <td>
                                    <div>
                                        <?php echo e(showAmount(1)); ?> = <?php echo e(showAmount($withdraw->rate, currencyFormat: false)); ?> <?php echo e(__($withdraw->currency)); ?>

                                        <br>
                                        <strong><?php echo e(showAmount($withdraw->final_amount, currencyFormat: false)); ?> <?php echo e(__($withdraw->currency)); ?></strong>
                                    </div>
                                </td>
                                <td>
                                    <?php echo $withdraw->statusBadge ?>
                                </td>
                                <td>
                                    <button class="btn btn--base btn--sm detailBtn"
                                            data-user_data="<?php echo e(json_encode($details)); ?>"
                                            <?php if($withdraw->status == Status::PAYMENT_REJECT): ?> data-admin_feedback="<?php echo e($withdraw->admin_feedback); ?>" <?php endif; ?>>
                                        <i class="la la-desktop"></i>
                                    </button>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
                <?php echo e(paginateLinks($withdraws)); ?>

            </div>
        </div>
    </section>

    <div class="modal custom--modal fade" id="detailModal" role="dialog" tabindex="-1">
        <div class="modal-dialog" role="document">
            <div class="modal-content section--bg">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo app('translator')->get('Details'); ?></h5>
                    <span class="close" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <i class="las la-times"></i>
                    </span>
                </div>
                <div class="modal-body">
                    <ul class="list-group list-group-flush payment-list userData"></ul>
                    <div class="feedback"></div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            $('.detailBtn').on('click', function() {
                var modal = $('#detailModal');
                var userData = $(this).data('user_data');
                var html = ``;
                userData.forEach(element => {
                    if (element.type != 'file') {
                        html += `
                        <li class="list-group-item d-flex justify-content-between align-items-center px-0">
                            <span>${element.name}</span>
                            <span">${element.value}</span>
                        </li>`;
                    }
                });
                modal.find('.userData').html(html);
                if ($(this).data('admin_feedback') != undefined) {
                    var adminFeedback = `
                        <div class="mt-3 text--dark">
                            <strong class="text--muted"><?php echo app('translator')->get('Admin Feedback'); ?></strong>
                            <p class="text-white">${$(this).data('admin_feedback')}</p>
                        </div>
                    `;
                } else {
                    var adminFeedback = '';
                }

                modal.find('.feedback').html(adminFeedback);

                modal.modal('show');
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/club/public_html/core/resources/views/templates/sunfyre/user/withdraw/log.blade.php ENDPATH**/ ?>