<?php
    $content = getContent('faq.content', true);
    $faqs = getContent('faq.element', orderById: true);
?>

<section class="faq-section py-50">
    <div class="container">
        <div class="faq-section-content">
            <div class="row gy-5 align-items-end justify-content-between">
                <div class="col-xxl-6 col-lg-6 order-2 order-lg-1">
                    <div class="section-heading style-left">
                        <h1 class="section-heading__title" s-break="-1" s-color="title-color"><?php echo e(__(@$content->data_values->heading)); ?></h1>
                        <p class="section-heading__desc"><?php echo e(__(@$content->data_values->subheading)); ?></p>
                    </div>
                    <div class="accordion custom--accordion" id="accordionExample">
                        <?php $__currentLoopData = $faqs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $faq): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="accordion-item">
                                <div class="accordion-header">
                                    <button class="accordion-button <?php if($loop->first): ?> collapsed <?php endif; ?>" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#collapse<?php echo e($loop->iteration); ?>" aria-expanded="<?php if($loop->first): ?> true <?php else: ?> false <?php endif; ?>" aria-controls="collapse<?php echo e($loop->iteration); ?>">
                                        <span class="accordion-title"><?php echo e(__(@$faq->data_values->question)); ?></span>
                                        <span class="accordion-icon"><i class="las la-angle-down"></i></span>
                                    </button>
                                </div>
                                <div id="collapse<?php echo e($loop->iteration); ?>" class="accordion-collapse collapse <?php if($loop->first): ?> show <?php endif; ?>"
                                     data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        <p class="text"><?php echo e(__(@$faq->data_values->answer)); ?></p>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
                <div class="col-xxl-5 col-lg-6 order-1 order-lg-2">
                    <div class="faq-thumbs">
                        <img src="<?php echo e(getImage('assets/images/frontend/faq/' . @$content->data_values->image, '560x565')); ?>" alt="<?php echo app('translator')->get('image'); ?>">
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php /**PATH /home/xbetwin/public_html/core/resources/views/templates/sunfyre/sections/faq.blade.php ENDPATH**/ ?>