<?php $__env->startSection('content'); ?>
    <div class="row gy-5 gx-lg-5 align-items-center">
        <div class="col-lg-6">
            <div class=" game--card">
                <div class=" number-slot-wrapper">
                    <div class="number-slot-box">
                        <div class='machine position-relative'>
                            <div class='slots'>
                                <ul class='slot' id="slot1">
                                    <li class='numbers'>0</li>
                                    <li class='numbers'>1</li>
                                    <li class='numbers'>2</li>
                                    <li class='numbers'>3</li>
                                    <li class='numbers'>4</li>
                                    <li class='numbers'>5</li>
                                    <li class='numbers'>6</li>
                                    <li class='numbers'>7</li>
                                    <li class='numbers'>8</li>
                                    <li class='numbers'>9</li>
                                </ul>
                                <ul class='slot' id="slot2">
                                    <li class='numbers'>0</li>
                                    <li class='numbers'>1</li>
                                    <li class='numbers'>2</li>
                                    <li class='numbers'>3</li>
                                    <li class='numbers'>4</li>
                                    <li class='numbers'>5</li>
                                    <li class='numbers'>6</li>
                                    <li class='numbers'>7</li>
                                    <li class='numbers'>8</li>
                                    <li class='numbers'>9</li>
                                </ul>
                                <ul class='slot' id="slot3">
                                    <li class='numbers'>0</li>
                                    <li class='numbers'>1</li>
                                    <li class='numbers'>2</li>
                                    <li class='numbers'>3</li>
                                    <li class='numbers'>4</li>
                                    <li class='numbers'>5</li>
                                    <li class='numbers'>6</li>
                                    <li class='numbers'>7</li>
                                    <li class='numbers'>8</li>
                                    <li class='numbers'>9</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-6">
            <div class="headtail-wrapper game-contet__sm">
                <h4 class="game-contet-title"><?php echo app('translator')->get('Current Balance'); ?>: <span class="text bal"><?php echo e(showAmount(auth()->user()->balance, currencyFormat: false)); ?> </span> <?php echo e(__(gs('cur_text'))); ?></h4>
                <form id="game" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="form-group">
                        <div class="input-group">
                            <span class="input-group-text"><?php echo e(gs('cur_sym')); ?></span>
                            <input type="number" step="any" class="form-control form--control" placeholder="<?php echo app('translator')->get('Enter amount'); ?>" name="invest" value="<?php echo e(old('invest')); ?>">
                            <button type="button" class="input-group-text minmax-btn minBtn"><?php echo app('translator')->get('Min'); ?></button>
                            <button type="button" class="input-group-text minmax-btn maxBtn"><?php echo app('translator')->get('Max'); ?></button>
                        </div>

                        <small class="fw-light mt-3 d-inline-block input-inner-note">
                            <i class="fas fa-info-circle mr-2"></i> <?php echo app('translator')->get('Minimum'); ?>
                            : <?php echo e(showAmount($game->min_limit)); ?> | <?php echo app('translator')->get('Maximum'); ?>
                            : <?php echo e(showAmount($game->max_limit)); ?></small>
                        <small class="form-text text-muted mb-3"><?php echo app('translator')->get('Win Amount'); ?> : <span class="text--warning"><?php echo app('translator')->get('Single'); ?> (<?php echo e(@$game->level[0]); ?>%)</span> | <span class="text--warning"><?php echo app('translator')->get('Double'); ?> (<?php echo e(@$game->level[1]); ?>%)</span> | <span class="text--warning"><?php echo app('translator')->get('Triple'); ?> (<?php echo e(@$game->level[2]); ?>%)</span>
                        </small>
                    </div>

                    <div class="form-group">
                        <input class="form--control choose-number" name="choose" type="number" min="0" max="9" placeholder="<?php echo app('translator')->get('Enter Number'); ?>" required>
                    </div>

                    <div class="form-submit game-playbtn">
                        <button type="submit" class="btn btn--gradient w-100"><?php echo app('translator')->get('Play Now'); ?></button>
                    </div>
                    <button type="button" class="d-block text-white text-center mx-auto mt-3" data-bs-toggle="modal" data-bs-target="#exampleModalCenter">
                        <i class="fas fa-info-circle mr-2"></i> <?php echo app('translator')->get('Game Instruction'); ?>
                    </button>
                </form>
            </div>
        </div>
    </div>

    <div class="modal custom--modal fade" id="exampleModalCenter" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content section--bg">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle"><?php echo app('translator')->get('Game Rule'); ?></h5>
                    <span class="close" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <i class="las la-times"></i>
                    </span>
                </div>
                <div class="modal-body">
                    <?php echo $game->instruction ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .number-slot-box .machine {
            width: 100%;
        }

        .choose-number {
            border-radius: 12px;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('style-lib'); ?>
    <link href="<?php echo e(asset('assets/global/css/game/slot.css')); ?>" rel="stylesheet">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script-lib'); ?>
    <script src="<?php echo e(asset('assets/global/js/game/slot.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        "use strict";

        let investField = $("[name=invest]");
        let minLimit = Number("<?php echo e($game->min_limit); ?>");
        let maxLimit = Number("<?php echo e($game->max_limit); ?>");
        let currency = "<?php echo e(gs('cur_text')); ?>";
        let audio;

        $(".minBtn").on('click', function(e) {
            audio = new Audio(`<?php echo e(asset('assets/audio/click.mp3')); ?>`);
            audio.play()
            investField.val(minLimit);
        });

        $(".maxBtn").on('click', function(e) {
            audio = new Audio(`<?php echo e(asset('assets/audio/click.mp3')); ?>`);
            audio.play()
            investField.val(maxLimit);
        });


        $('input[name=invest]').keypress(function(e) {
            var character = String.fromCharCode(e.keyCode)
            var newValue = this.value + character;
            if (isNaN(newValue) || hasDecimalPlace(newValue, 3)) {
                e.preventDefault();
                return false;
            }
        });

        function hasDecimalPlace(value, x) {
            var pointIndex = value.indexOf('.');
            return pointIndex >= 0 && pointIndex < value.length - x;
        }

        $('#game').on('submit', function(e) {
            e.preventDefault();

            if (!$('[name=invest]').val()) {
                notify('error', 'Invest amount is required')
                return;
            }
            if (!$('[name=choose]').val()) {
                notify('error', 'Choose number is required')
                return;
            }

            audio = new Audio(`<?php echo e(asset('assets/audio/number-slot.mp3')); ?>`)
            audio.play();
            $('button[type=submit]').html('<i class="la la-gear fa-spin"></i> Processing...');
            $('button[type=submit]').attr('disabled', '');
            $('.alert').remove();
            var data = $(this).serialize();
            var url = "<?php echo e(route('user.play.game.invest', 'number_slot')); ?>";
            game(data, url);
        });

        function endGame(data) {
            var url = "<?php echo e(route('user.play.game.end', 'number_slot')); ?>";
            audio.pause();
            complete(data, url);
        }

        function playAudio(filename) {
            var audio = new Audio(`<?php echo e(asset('assets/audio')); ?>/${filename}`);
            audio.play();
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/xbetwin/public_html/core/resources/views/templates/sunfyre/user/games/number_slot.blade.php ENDPATH**/ ?>