<?php
    $contactContent = getContent('contact_us.content', true);
    $contactElement = getContent('contact_us.element', false, null, true);
?>

<?php $__env->startSection('content'); ?>

    <section class="contact-info pt-100 pb-50">
        <div class="container">
            <div class="info-wrapper">
                <div class="info-card">
                    <div class="info-card__icon">
                        <i class="icon icon-Map"></i>
                    </div>
                    <div class="info-card__content">
                        <h4 class="info-card__title"><?php echo app('translator')->get('Our Address'); ?></h4>
                        <p class="info-card__desc"><?php echo e(__(@$contactContent->data_values->contact_address)); ?></p>
                    </div>
                </div>
                <div class="info-card">
                    <div class="info-card__icon">
                        <i class="icon icon-Telepphone"></i>
                    </div>
                    <div class="info-card__content">
                        <h4 class="info-card__title"><?php echo app('translator')->get('Call Us'); ?></h4>
                        <ul class="info-card__list">
                            <li class="info-card__list-item">
                                <a class="info-card__list-link" href="tel:<?php echo e(@$contactContent->data_values->contact_number); ?>"><?php echo e(@$contactContent->data_values->contact_number); ?></a>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="info-card">
                    <div class="info-card__icon">
                        <i class="icon icon-Email"></i>
                    </div>
                    <div class="info-card__content">
                        <h4 class="info-card__title"><?php echo app('translator')->get('Mail Us'); ?></h4>
                        <ul class="info-card__list">
                            <li class="info-card__list-item">
                                <a class="info-card__list-link" href="mailto:<?php echo e(@$contactContent->data_values->email_address); ?>"><?php echo e(@$contactContent->data_values->email_address); ?></a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="contact py-50">
        <div class="container">
            <div class="contact-wrapper">
                <div class="row gy-5 align-items-center">
                    <div class="col-lg-6 order-2 order-lg-1">
                        <div class="contact-form">
                            <h2 class="contact-form__title"><?php echo e(__(@$contactContent->data_values->heading)); ?></h2>
                            <form method="POST" class="verify-gcaptcha">
                                <?php echo csrf_field(); ?>
                                <div class="form-group">
                                    <label class="form--label"><?php echo app('translator')->get('Full Name'); ?></label>
                                    <div class="input-inner">
                                        <span class="input-inner__icon">
                                            <i class="fas fa-user"></i>
                                        </span>
                                        <input name="name" type="text" class="form--control" value="<?php echo e(old('name', @$user->fullname)); ?>" <?php if($user && $user->profile_complete): ?> readonly <?php endif; ?> required>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label class="form--label"><?php echo app('translator')->get('Email Address'); ?></label>
                                    <div class="input-inner">
                                        <span class="input-inner__icon">
                                            <i class="fas fa-envelope"></i>
                                        </span>
                                        <input class="form--control" name="email" type="email" value="<?php echo e(old('email', @$user->email)); ?>" <?php if($user): ?> readonly <?php endif; ?> required>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label class="form--label"><?php echo app('translator')->get('Subject'); ?></label>
                                    <div class="input-inner">
                                        <span class="input-inner__icon">
                                            <i class="fas fa-file-alt"></i>
                                        </span>
                                        <input class="form--control" name="subject" type="text" value="<?php echo e(old('subject')); ?>" required>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label class="form--label"><?php echo app('translator')->get('Message'); ?></label>
                                    <textarea class="form--control" name="message"><?php echo e(old('message')); ?></textarea>
                                </div>

                                <?php if (isset($component)) { $__componentOriginalff0a9fdc5428085522b49c68070c11d6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalff0a9fdc5428085522b49c68070c11d6 = $attributes; } ?>
<?php $component = App\View\Components\Captcha::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('captcha'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Captcha::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalff0a9fdc5428085522b49c68070c11d6)): ?>
<?php $attributes = $__attributesOriginalff0a9fdc5428085522b49c68070c11d6; ?>
<?php unset($__attributesOriginalff0a9fdc5428085522b49c68070c11d6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalff0a9fdc5428085522b49c68070c11d6)): ?>
<?php $component = $__componentOriginalff0a9fdc5428085522b49c68070c11d6; ?>
<?php unset($__componentOriginalff0a9fdc5428085522b49c68070c11d6); ?>
<?php endif; ?>

                                <div class="form-submit mt-50">
                                    <button type="submit" class="btn btn--gradient w-100"><?php echo app('translator')->get('Submit'); ?></button>
                                </div>
                            </form>
                        </div>
                    </div>
                    <div class="col-lg-6 order-1 order-lg-2">
                        <div class="contact-thumb">
                            <img src="<?php echo e(getImage('assets/images/frontend/contact_us/' . @$contactContent->data_values->image, '560x565')); ?>" alt="<?php echo app('translator')->get('image'); ?>">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <?php if(@$sections->secs != null): ?>
        <?php $__currentLoopData = json_decode($sections->secs); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sec): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php echo $__env->make($activeTemplate . 'sections.' . $sec, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/club/public_html/core/resources/views/templates/sunfyre/contact.blade.php ENDPATH**/ ?>