<?php
    $testimonialContent = getContent('testimonial.content', true);
    $testimonialElement = getContent('testimonial.element', orderById: true);
?>
<section class="testimonials py-50">
    <div class="container">
        <div class="testimonials-wrapper">
            <div class="row gy-5 align-items-center justify-content-between">
                <div class="col-xxl-6 col-xl-7 col-lg-5">
                    <div class="card-slider testimonials-slider">
                        <?php $__currentLoopData = $testimonialElement; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $testimonial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="card-item">
                                <div class="card-item__content">
                                    <div class="card-item__image-lg card-item__image">
                                        <img src="<?php echo e(getImage('assets/images/frontend/testimonial/' . @$testimonial->data_values->image, '90x80')); ?>" alt="<?php echo app('translator')->get('image'); ?>">
                                    </div>
                                    <h5 class="card-item__title"><?php echo e(__(@$testimonial->data_values->name)); ?></h5>
                                    <p class="card-item__desc"><?php echo e(__(@$testimonial->data_values->quote)); ?></p>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <div class="testimonials-slider-dots"></div>
                </div>
                <div class="col-xxl-5 col-xl-5 col-lg-7">
                    <div class="choose-us-content">
                        <div class="section-heading style-left">
                            <h1 class="section-heading__title" s-break="-1" s-color="title-color"><?php echo e(__(@$testimonialContent->data_values->heading)); ?></h1>
                            <p class="section-heading__desc"><?php echo e(__(@$testimonialContent->data_values->description)); ?></p>
                        </div>
                        <a href="<?php echo e(url(@$testimonialContent->data_values->button_url)); ?>" class="btn btn--gradient" tabindex="0"><?php echo e(__(@$testimonialContent->data_values->button_name)); ?></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php /**PATH /home/club/public_html/core/resources/views/templates/sunfyre/sections/testimonial.blade.php ENDPATH**/ ?>