
<?php $__env->startSection('content'); ?>
    <div class="row">
        <?php if(auth()->user()->referrer): ?>
            <h4 class="mb-2"><?php echo app('translator')->get('You are referred by'); ?> <?php echo e(auth()->user()->referrer->fullname); ?></h4>
        <?php endif; ?>
        <div class="col-md-12">
            <div class="form-group">
                <div class="input-group">
                    <input class="form-control form--control referralURL" type="text" value="<?php echo e(route('home')); ?>?reference=<?php echo e(auth()->user()->username); ?>" readonly>
                    <button class="input-group-text copytext" id="copyBoard" type="button"><i class="fas fa-copy"></i></button>
                </div>
            </div>
        </div>
    </div>
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card custom--card">
                <div class="card-body">
                    <?php if($user->allReferrals->count() > 0 && $maxLevel > 0): ?>
                        <div class="treeview-container">
                            <ul class="treeview">
                                <li class="items-expanded"> <?php echo e($user->fullname); ?> ( <?php echo e($user->username); ?> )
                                    <?php echo $__env->make($activeTemplate . 'partials.under_tree', ['user' => $user, 'layer' => 0, 'isFirst' => true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </li>
                            </ul>
                        </div>
                    <?php else: ?>
                        <div class="text-center">
                            <h5><?php echo e(__($emptyMessage)); ?></h5>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style-lib'); ?>
    <link type="text/css" href="<?php echo e(asset('assets/global/css/jquery.treeView.css')); ?>" rel="stylesheet">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script-lib'); ?>
    <script src="<?php echo e(asset('assets/global/js/jquery.treeView.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('style'); ?>
    <style type="text/css">
        @media (max-width: 425px) {
            .input-group-text {
                height: 49px;
            }
        }

        .copied::after {
            background-color: #<?php echo e(gs('base_color')); ?>

        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            $('.treeview').treeView();

            $('#copyBoard').click(function() {
                var copyText = document.getElementsByClassName("referralURL");
                copyText = copyText[0];
                copyText.select();
                copyText.setSelectionRange(0, 99999);
                /*For mobile devices*/
                document.execCommand("copy");
                copyText.blur();
                this.classList.add('copied');
                setTimeout(() => this.classList.remove('copied'), 1500);
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/club/public_html/core/resources/views/templates/sunfyre/user/referrals.blade.php ENDPATH**/ ?>