<?php
    $payment = getContent('payment_method.content', true);
    $payments = getContent('payment_method.element', false, null, true);
    $policyPages = getContent('policy_pages.element', false, null, true);
    $socialIcon = getContent('social_icon.element', false, null, true);
    $footer = getContent('footer.content', true);
?>




<?php if(auth()->guard()->check()): ?>
<div class="sc-bottom-bar">
  <a class="sc-menu-item" href="<?php echo e(route('user.home')); ?>">
    <i class="fas fa-home"></i>
    <p class="sdfasdfdf">Home</p>  
  </a>

  <a class="sc-menu-item" href="<?php echo e(route('user.deposit.index')); ?>">
    <i class="fas fa-plus-circle"></i>
    <p class="sdfasdfdf">Deposit</p>
  </a>

  <a class="sc-menu-item sc-current" href="<?php echo e(route('user.wellet')); ?>">
    <i class="fas fa-wallet"></i>
    <p class="sdfasdfdf">Wallet</p>
  </a>

  <div class="sc-nav-indicator"></div> 

  <a class="sc-menu-item" href="<?php echo e(route('user.withdraw')); ?>">
    <i class="fas fa-money-bill-alt"></i>
    <p class="sdfasdfdf">Withdraw</p> 
  </a>

  <a class="sc-menu-item" href="<?php echo e(route('user.profile_d')); ?>">
    <i class="fas fa-user"></i>
    <p class="sdfasdfdf">Profile</p>  
  </a>
</div>


<style>
    :root{
  --primary-color:#0D6FFA;
  --accent-color:#49CE95;
  --danger-color:#EC3582;
  --fore-color:rgba(0,0,0,0.65);
  --main-cast-shadow: 0px 3px 12px rgba(0, 0, 0, 0.08), 0px 3px 6px rgba(0, 0, 0, 0.12);
}
.sc-current .sdfasdfdf{
    display:none;
}
.sc-bottom-bar {
    position: fixed;
    display: flex;
    padding: 4px 15px;
    justify-content: space-between;
    z-index: 99999;
    margin: auto;
    left: 0;
    bottom: 0;
    right: 0;
    font-size: 26px;
    background-image: radial-gradient(circle at 36px 6px, transparent 36px, #000 37px);
    filter: drop-shadow(0px -1px 6px rgba(0, 0, 0, 0.08)) drop-shadow(0px -2px 12px rgba(0, 0, 0, 0.12));
    transition: cubic-bezier(0.57, 0.23, 0.08, 0.96) .45s;
}
.sc-nav-indicator {
  position: absolute;
  width: 56px;
  height: 56px;
  bottom: 28px;
  left: 0;
  background-color: #000;
  box-shadow: var(--main-cast-shadow);
  border-radius: 50%;
  z-index: 2;
  transition: cubic-bezier(0.45, 0.73, 0, 0.59) .3s;
}
p.sdfasdfdf {
    color: #fff;
}
.sc-menu-item {
    color: var(--fore-color);
    transition: ease-in-out .5s;
    text-align: center;
    cursor: pointer;
}
.sc-current {
    position: relative;
    color: #ffffff;
    z-index: 3;
    transform: translate3d(0px, -13px, 0px);
}
@media screen and (max-width: 575px) {
    .footer-area {
        margin-top: 120px;
        margin-bottom: 77px;
    }
}
.sc-menu-item i {
    color: rgb(188 0 0);
    font-size: 19px;
}
</style>

<script>
var menu_bar = document.querySelector('.sc-bottom-bar');
var menu_item = document.querySelectorAll('.sc-menu-item');
var menu_indicator = document.querySelector('.sc-nav-indicator');
var menu_current_item = document.querySelector('.sc-current');
var menu_position;

menu_position = menu_current_item.offsetLeft - 16;
menu_indicator.style.left = menu_position + "px";
menu_bar.style.backgroundPosition = menu_position-8 + 'px';

menu_item.forEach(function(select_menu_item){
  select_menu_item.addEventListener('click', function(){
    // menu_position = this.offsetLeft - 16;
    // menu_indicator.style.left = menu_position + "px";
    // menu_bar.style.backgroundPosition = menu_position-8 + 'px';

    [...select_menu_item.parentElement.children].forEach(
      sibling => {
        sibling.classList.remove('sc-current');
      }
    );
    select_menu_item.classList.add('sc-current');
  });
});

</script>
<?php endif; ?>







<footer class="footer-area">
    <div class="footer-area__thumb">
        <img src="<?php echo e(getImage('assets/images/frontend/footer/' . $footer->data_values->image, '1110x420')); ?>" alt="<?php echo app('translator')->get('image'); ?>">
    </div>
    <div class="payment-method pb-100">
        <div class="container">
            <h4 class="payment-method__title"><?php echo e(__(@$payment->data_values->heading)); ?></h4>
            <div class="payment-slider">
                <?php $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="payment-single-item">
                        <div class="payment-item__image">
                            <img src="<?php echo e(getImage('assets/images/frontend/payment_method/' . $item->data_values->image, '90x65')); ?>" alt="<?php echo app('translator')->get('image'); ?>">
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>

    <div class="footer-bottom py-50">
        <div class="container">
            <div class="footer-bottom__wrapper">
                <a href="" class="footer-bottom__logo">
                    <img src="<?php echo e(siteLogo()); ?>" alt="<?php echo app('translator')->get('image'); ?>">
                </a>

                <div class="newsletter">
                    <form class="newsletter__wrapper">
                        <div class="newsletter__input">
                            <input class="form--control" name="email" type="email" placeholder="<?php echo app('translator')->get('Enter email address'); ?>" autocomplete="off">
                        </div>
                        <button type="submit" class="newsletter__btn subscribe-btn"><?php echo app('translator')->get('Subscribe'); ?></button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="socket-area">
        <div class="container">
            <div class="socket-area__wrapper">
                <p class="socket-area__text"> &copy; <?php echo app('translator')->get('Copyright'); ?> <?php echo date('Y') ?> . <?php echo app('translator')->get('All rights reserved'); ?>.</p>
                <ul class="social-list">
                    <?php $__currentLoopData = $socialIcon; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $social): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="social-list__item">
                            <a href="<?php echo e(@$social->data_values->url); ?>" class="social-list__link flex-center">
                                <?php echo $social->data_values->social_icon ?>
                            </a>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
                <ul class="flex-align socket-nav">
                    <?php $__currentLoopData = $policyPages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $policy): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="socket-nav__item">
                            <a class="socket-nav__link" href="<?php echo e(route('policy.pages', @$policy->slug)); ?>"><?php echo e(__(@$policy->data_values->title)); ?></a>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        </div>
    </div>
</footer>
<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            $('.subscribe-btn').on('click', function(e) {
                e.preventDefault()
                var email = $('[name=email]').val();
                $.ajax({
                    headers: {
                        "X-CSRF-TOKEN": "<?php echo e(csrf_token()); ?>",
                    },
                    url: "<?php echo e(route('subscribe.post')); ?>",
                    method: "POST",
                    data: {
                        email: email
                    },
                    success: function(response) {
                        if (response.success) {
                            $('[name=email]').val('')
                            notify('success', response.success);
                        } else {
                            notify('error', response.error);
                        }
                    }
                });
            });
        })(jQuery)
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/easyearning/public_html/core/resources/views/templates/sunfyre/partials/footer.blade.php ENDPATH**/ ?>