
<?php $__env->startSection('content'); ?>
    <div class="row gy-4">
        <div class="col-lg-6 mt-lg-0 mt-5">
            <div class="game--card">
                <div class="mine-box-wrapper">
                    <?php for($i = 1; $i <= 25; $i++): ?>
                        <div class="mine-box mineBox gold-box" id="mine<?php echo e($i); ?>">
                            <div class="mine-box-wrapper">
                                <div class="mine-box-front">
                                    <img src="<?php echo e(asset($activeTemplateTrue . 'images/mines/box.png')); ?>" alt="<?php echo app('translator')->get('image'); ?>">
                                </div>
                                <div class="mine-box-hidden"></div>
                            </div>
                        </div>
                    <?php endfor; ?>
                </div>
            </div>
        </div>
        <div class="col-lg-6">
            <div class="game--card">
                <h4 class="game-contet-title"><?php echo app('translator')->get('Current Balance'); ?>: <span class="text balance"><?php echo e(showAmount(auth()->user()->balance, currencyFormat: false)); ?></span> <?php echo e(__(gs('cur_text'))); ?></h4>
                <div class="form-group bet-input">
                    <label class="form-label"><?php echo app('translator')->get('Bet Amount'); ?></label>
                    <div class="input-group">
                        <span class="input-group-text"><?php echo e(gs('cur_sym')); ?></span>
                        <input type="number" step="any" class="form-control form--control" placeholder="<?php echo app('translator')->get('Enter amount'); ?>" name="invest">
                        <button type="button" class="input-group-text minmax-btn minBtn"><?php echo app('translator')->get('Min'); ?></button>
                        <button type="button" class="input-group-text minmax-btn maxBtn"><?php echo app('translator')->get('Max'); ?></button>
                    </div>

                    <div class="fw-light mt-3 d-inline-block input-inner-note">
                        <small class="form-text text-muted">
                            <i class="fas fa-info-circle mr-2"></i> <?php echo app('translator')->get('Minimum :'); ?> <?php echo e(showAmount($game->min_limit)); ?>

                            | <?php echo app('translator')->get('Maximum :'); ?> <?php echo e(showAmount($game->max_limit)); ?>

                        </small>

                    </div>
                </div>
                <div class="form-group mines-input">
                    <label class="form-label"><?php echo app('translator')->get('Number of Mines'); ?></label>
                    <input type="number" class="form-control form--control mines-number" name="mines" min="1" max="20">
                </div>

                <div class="gold-mine-box"></div>

                <div class="form-submit game-playbtn mt-5">
                    <button type="button" class="btn btn--gradient w-100 betBtn"><?php echo app('translator')->get('Start Game'); ?></button>
                    <button type="button" class="btn btn--gradient w-100 d-none  cashoutBtn"><?php echo app('translator')->get('Cashout'); ?></button>
                </div>
                <button type="button" class="d-block text-white text-center mx-auto mt-3" data-bs-toggle="modal" data-bs-target="#exampleModalCenter"><i
                       class="fas fa-info-circle mr-2"></i>
                    <?php echo app('translator')->get(' Game Instruction'); ?>
                </button>
            </div>
        </div>
    </div>

    <!-- Modal -->
    <div class="modal custom--modal fade" id="exampleModalCenter" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content section--bg">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle"><?php echo app('translator')->get('Game Rule'); ?></h5>
                    <span class="close" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <i class="las la-times"></i>
                    </span>
                </div>
                <div class="modal-body">
                    <?php echo $game->instruction ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .minmax-btn {
            position: relative;
        }

        .minmax-btn:not(:last-child)::after {
            content: "";
            position: absolute;
            height: 20px;
            width: 2px;
            background-color: hsl(var(--black));
            top: 50%;
            transform: translateY(-50%);
            right: 0;
        }

        .mines-number {
            border-radius: 12px;
        }

        .gold-mine-box {
            display: flex;
            align-items: center;
            justify-content: center;
            flex-wrap: wrap;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script src="<?php echo e(asset('assets/global/js/game/mines.js')); ?>"></script>
    <script>
        "use strict";
        (function($) {
            let minLimit = Number("<?php echo e($game->min_limit); ?>");
            let maxLimit = Number("<?php echo e($game->max_limit); ?>");
            let currency = "<?php echo e(gs('cur_text')); ?>";
            let userBalance = Number("<?php echo e(auth()->user()->balance); ?>");
            let audio;

            $(".minBtn").on('click', function(e) {
                audio = new Audio(`<?php echo e(asset('assets/audio/click.mp3')); ?>`);
                audio.play()
                investField.val(minLimit);
            });

            $(".maxBtn").on('click', function(e) {
                audio = new Audio(`<?php echo e(asset('assets/audio/click.mp3')); ?>`);
                audio.play()
                investField.val(maxLimit);
            });

            $('.betBtn').on('click', function(e) {

                let invest = investField.val();
                let mines = minesField.val();

                if (!invest) {
                    notify('error', `Amount field is required`);
                    return;
                }
                if (!mines) {
                    notify('error', `Mines field is required`);
                    return;
                }

                if (minLimit > invest) {
                    notify('error', `Minimum bet amount is ${minLimit} `);
                    return;
                }

                if (invest > maxLimit) {
                    notify('error', `Maximum bet amount is ${minLimit} `);
                    return;
                }

                if (mines > 20) {
                    notify('error', `Maximum mines amount is 20`);
                    return;
                }

                if (invest > userBalance) {
                    notify('error', `You have no sufficient balance`);
                    return;
                }

                audio = new Audio(`<?php echo e(asset('assets/audio/start.mp3')); ?>`);
                audio.play()

                betBtn.prop('disabled', true);
                betBtn.addClass('d-none');

                let url = "<?php echo e(route('user.play.game.invest', 'mines')); ?>"
                let data = {
                    _token: "<?php echo e(csrf_token()); ?>",
                    invest: invest,
                    mines: mines
                }
                game(url, data);
            });

            $('.mineBox').on('click', function(e) {
                audio = new Audio(`<?php echo e(asset('assets/audio/click.mp3')); ?>`);
                audio.play()
                let mineUrl = "<?php echo e(route('user.play.game.end', 'mines')); ?>"
                let mineData = {
                    _token: "<?php echo e(csrf_token()); ?>",
                    game_id: gameLogId
                }
                mineBox = $(this);
                gameEnd(mineUrl, mineData);
            });

            $('.cashoutBtn').on('click', function(e) {
                let cashoutUrl = "<?php echo e(route('user.play.mine.cashout')); ?>"
                let cashoutData = {
                    _token: "<?php echo e(csrf_token()); ?>",
                    game_id: gameLogId
                }
                cashout(cashoutUrl, cashoutData);
            });
        })(jQuery)
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/easyearning/public_html/core/resources/views/templates/sunfyre/user/games/mines.blade.php ENDPATH**/ ?>