
<?php $__env->startSection('content'); ?>
    <?php
        $gesBon = App\Models\GuessBonus::where('alias', $game->alias)
            ->orderBy('chance', 'asc')
            ->pluck('percent')
            ->toArray();
    ?>

    <div class="row gy-4">
        <div class="col-xl-9" id="game--card">
            <div class="game--card">
                <div class="row align-items-center gy-4">
                    <div class="col-md-3">
                        <div class="card-item">
                            <div class="card-item__thumb">
                                <img src="<?php echo e(asset($activeTemplateTrue . 'images/poker/royal_flush.png')); ?>" alt="<?php echo app('translator')->get('image'); ?>">
                            </div>
                            <div class="card-item__text">
                                <span class="card-item__icon"> <i class="las la-times"></i></span>
                                <?php echo e(getAmount(@$gesBon[0])); ?><?php echo app('translator')->get('%'); ?>
                            </div>
                        </div>
                        <div class="card-item">
                            <div class="card-item__thumb">
                                <img src="<?php echo e(asset($activeTemplateTrue . 'images/poker/straight_flush.png')); ?>" alt="<?php echo app('translator')->get('image'); ?>">
                            </div>
                            <div class="card-item__text">
                                <span class="card-item__icon"> <i class="las la-times"></i></span>
                                <?php echo e(getAmount(@$gesBon[1])); ?><?php echo app('translator')->get('%'); ?>
                            </div>
                        </div>
                        <div class="card-item">
                            <div class="card-item__thumb">
                                <img src="<?php echo e(asset($activeTemplateTrue . 'images/poker/four_kind.png')); ?>" alt="<?php echo app('translator')->get('image'); ?>">
                            </div>
                            <div class="card-item__text">
                                <span class="card-item__icon"> <i class="las la-times"></i></span>
                                <?php echo e(getAmount(@$gesBon[2])); ?><?php echo app('translator')->get('%'); ?>
                            </div>
                        </div>
                        <div class="card-item">
                            <div class="card-item__thumb">
                                <img src="<?php echo e(asset($activeTemplateTrue . 'images/poker/full_house.png')); ?>" alt="<?php echo app('translator')->get('image'); ?>">
                            </div>
                            <div class="card-item__text">
                                <span class="card-item__icon"> <i class="las la-times"></i></span>
                                <?php echo e(getAmount(@$gesBon[3])); ?><?php echo app('translator')->get('%'); ?>
                            </div>
                        </div>
                        <div class="card-item">
                            <div class="card-item__thumb">
                                <img src="<?php echo e(asset($activeTemplateTrue . 'images/poker/flash.png')); ?>" alt="<?php echo app('translator')->get('image'); ?>">
                            </div>
                            <div class="card-item__text">
                                <span class="card-item__icon"> <i class="las la-times"></i></span>
                                <?php echo e(getAmount(@$gesBon[4])); ?><?php echo app('translator')->get('%'); ?>
                            </div>
                        </div>
                        <div class="card-item">
                            <div class="card-item__thumb">
                                <img src="<?php echo e(asset($activeTemplateTrue . 'images/poker/straight.png')); ?>" alt="<?php echo app('translator')->get('image'); ?>">
                            </div>
                            <div class="card-item__text">
                                <span class="card-item__icon"> <i class="las la-times"></i></span>
                                <?php echo e(getAmount(@$gesBon[5])); ?><?php echo app('translator')->get('%'); ?>
                            </div>
                        </div>
                        <div class="card-item">
                            <div class="card-item__thumb">
                                <img src="<?php echo e(asset($activeTemplateTrue . 'images/poker/three_kind.png')); ?>" alt="<?php echo app('translator')->get('image'); ?>">
                            </div>
                            <div class="card-item__text">
                                <span class="card-item__icon"> <i class="las la-times"></i></span>
                                <?php echo e(getAmount(@$gesBon[6])); ?><?php echo app('translator')->get('%'); ?>
                            </div>
                        </div>
                        <div class="card-item">
                            <div class="card-item__thumb">
                                <img src="<?php echo e(asset($activeTemplateTrue . 'images/poker/two_pair.png')); ?>" alt="<?php echo app('translator')->get('image'); ?>">
                            </div>
                            <div class="card-item__text">
                                <span class="card-item__icon"> <i class="las la-times"></i></span>
                                <?php echo e(getAmount(@$gesBon[7])); ?><?php echo app('translator')->get('%'); ?>
                            </div>
                        </div>
                        <div class="card-item">
                            <div class="card-item__thumb">
                                <img src="<?php echo e(asset($activeTemplateTrue . 'images/poker/one_pair.png')); ?>" alt="<?php echo app('translator')->get('image'); ?>">
                            </div>
                            <div class="card-item__text">
                                <span class="card-item__icon"> <i class="las la-times"></i></span>
                                <?php echo e(getAmount(@$gesBon[8])); ?><?php echo app('translator')->get('%'); ?>
                            </div>
                        </div>
                        <div class="card-item">
                            <div class="card-item__thumb">
                                <img src="<?php echo e(asset($activeTemplateTrue . 'images/poker/high_card.png')); ?>" alt="<?php echo app('translator')->get('image'); ?>">
                            </div>
                            <div class="card-item__text">
                                <span class="card-item__icon"> <i class="las la-times"></i></span>
                                <?php echo e(getAmount(@$gesBon[9])); ?><?php echo app('translator')->get('%'); ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-9">
                        <div class="poker-card-table">
                            <div class="poker-table">
                                <div class="poker-table__wrapper">
                                    <div class="poker-table__thumb">
                                        <img src="<?php echo e(asset($activeTemplateTrue . 'images/cards/BACK.png')); ?>" alt="<?php echo app('translator')->get('image'); ?>">
                                    </div>
                                    <div class="poker-table__thumb">
                                        <img src="<?php echo e(asset($activeTemplateTrue . 'images/cards/BACK.png')); ?>" alt="<?php echo app('translator')->get('image'); ?>">
                                    </div>
                                    <div class="poker-table__thumb">
                                        <img src="<?php echo e(asset($activeTemplateTrue . 'images/cards/BACK.png')); ?>" alt="<?php echo app('translator')->get('image'); ?>">
                                    </div>
                                    <div class="poker-table__thumb">
                                        <img src="<?php echo e(asset($activeTemplateTrue . 'images/cards/BACK.png')); ?>" alt="<?php echo app('translator')->get('image'); ?>">
                                    </div>
                                    <div class="poker-table__thumb">
                                        <img src="<?php echo e(asset($activeTemplateTrue . 'images/cards/BACK.png')); ?>" alt="<?php echo app('translator')->get('image'); ?>">
                                    </div>
                                </div>
                            </div>
                            <div class="poker-card__bottom refresh-area">
                                <div class="form-submit game-playbtn">
                                    <button class="btn btn--gradient refreshBtn" type="button">
                                        <?php echo app('translator')->get('Refresh'); ?>
                                    </button>
                                </div>
                            </div>

                            <div class="poker-card__bottom deal-area">
                                <div class="form-submit game-playbtn">
                                    <button class="btn btn--gradient dealBtn" type="button">
                                        <?php echo app('translator')->get('DEAL'); ?>
                                    </button>
                                </div>
                            </div>

                            <div class="poker-card__bottom action-area">
                                <div class="form-submit game-playbtn">
                                    <button class="btn btn--gradient callBtn" type="button">
                                        <?php echo app('translator')->get('CALL'); ?>
                                    </button>
                                    <button class="btn btn--gradient foldBtn" type="button">
                                        <?php echo app('translator')->get('FOLD'); ?>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3" id="form--area">
            <div class="game--card">
                <h4 class="game-contet-title"><?php echo app('translator')->get('Current Balance'); ?>:
                    <span class="text balance"><?php echo e(showAmount(auth()->user()->balance, currencyFormat: false)); ?></span> <?php echo e(__(gs('cur_text'))); ?>

                </h4>
                <form id="game" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="form-group">
                        <div class="input-group">
                            <input class="form-control form--control" name="invest" type="number" step="any" value="<?php echo e(old('invest')); ?>" placeholder="<?php echo app('translator')->get('Enter amount'); ?>" autocomplete="off">
                            <span class="input-group-text"><?php echo e(__(gs('cur_text'))); ?></span>
                        </div>
                        <small class="fw-light mt-3 d-inline-block input-inner-note">
                            <i class="fas fa-info-circle mr-2"></i> <?php echo app('translator')->get('Invest Limit'); ?>
                            : <?php echo e(showAmount($game->min_limit)); ?> -
                            <?php echo e(showAmount($game->max_limit)); ?>

                        </small>
                    </div>
                    <div class="form-submit game-playbtn">
                        <button type="submit" class="btn btn--gradient w-100"><?php echo app('translator')->get('Play Now'); ?></button>
                    </div>
                    <button type="button" class="d-block text-white text-center mx-auto mt-3" data-bs-toggle="modal" data-bs-target="#exampleModalCenter"><i
                           class="fas fa-info-circle mr-2"></i>
                        <?php echo app('translator')->get('Game Instruction'); ?>
                    </button>
                </form>
            </div>
        </div>
    </div>

    <!-- Modal -->
    <div class="modal custom--modal fade" id="exampleModalCenter" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content section--bg">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle"><?php echo app('translator')->get('Game Rule'); ?></h5>
                    <span class="close" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <i class="las la-times"></i>
                    </span>
                </div>
                <div class="modal-body">
                    <?php echo $game->instruction ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .card-item::before {
            background-image: unset;
        }

        .card-item::after {
            background-image: unset;
        }

        .card-item {
            border: none;
        }

        .btn--gradient.callBtn,
        .btn--gradient.foldBtn,
        .btn--gradient.dealBtn,
        .btn--gradient.refreshBtn {
            padding: 12px 20px !important;
            font-size: 20px !important;
            border-radius: 8px;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script src="<?php echo e(asset('assets/global/js/game/poker.js')); ?>"></script>

    <script>
        "use strict";
        (function($) {

            let userBalance = Number("<?php echo e(auth()->user()->balance); ?>");
            let minLimit = Number("<?php echo e($game->min_limit); ?>");
            let maxLimit = Number("<?php echo e($game->max_limit); ?>");
            let currency = "<?php echo e(gs('cur_text')); ?>";
            let audio;

            $('#game').on('submit', function(e) {
                e.preventDefault();
                invest = investField.val();
                if (!invest) {
                    notify('error', 'Invest field is required');
                    return;
                }
                if (minLimit > invest) {
                    notify('error', `Minimum invest is ${minLimit} ${currency}`);
                    return;
                }
                if (invest > maxLimit) {
                    notify('error', `Maximum invest is ${maxLimit} ${currency}`);
                    return;
                }
                if (invest > userBalance) {
                    notify('error', 'You have no sufficent balance');
                    return;
                }

                let previousId = localStorage.getItem("sessionId");
                if (previousId) {
                    notify('error', 'Please refresh the card');
                    return;
                }

                investBtn.addClass("d-none")

                let investUrl = "<?php echo e(route('user.play.game.invest', $game->alias)); ?>";
                let data = {
                    _token: "<?php echo e(csrf_token()); ?>",
                    invest: invest
                };
                game(investUrl, data)
            });
            $('.dealBtn').on('click', function(e) {
                audio = new Audio(`<?php echo e(asset('assets/audio/click.mp3')); ?>`);
                audio.play()
                if (!gameLogId) {
                    notify('error', 'Invalid request');
                }
                let dealUrl = "<?php echo e(route('user.play.game.poker.deal')); ?>";
                let dealData = {
                    _token: "<?php echo e(csrf_token()); ?>",
                    game_id: gameLogId
                }
                deal(dealUrl, dealData);
            });
            $('.callBtn').on('click', function(e) {
                audio = new Audio(`<?php echo e(asset('assets/audio/click.mp3')); ?>`);
                audio.play()
                if (!gameLogId) {
                    notify('error', 'Invalid request');
                }

                $(this).prop('disabled', true);

                let callUrl = "<?php echo e(route('user.play.game.poker.call')); ?>";
                let callData = {
                    _token: "<?php echo e(csrf_token()); ?>",
                    game_id: gameLogId
                }
                call(callUrl, callData);
            });
            $('.foldBtn').on('click', function(e) {
                audio = new Audio(`<?php echo e(asset('assets/audio/click.mp3')); ?>`);
                audio.play()

                if (!gameLogId) {
                    notify('error', 'Invalid request');
                }

                $(this).prop('disabled', true);

                let foldUrl = "<?php echo e(route('user.play.game.poker.fold')); ?>";
                let foldData = {
                    _token: "<?php echo e(csrf_token()); ?>",
                    game_id: gameLogId
                }
                fold(foldUrl, foldData);
            });
        })(jQuery)
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/xbetwin/public_html/core/resources/views/templates/sunfyre/user/games/poker.blade.php ENDPATH**/ ?>